<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:altova="http://www.altova.com"
                xmlns:altova-xfi="http://www.altova.com/xslt-extensions/xbrl"
                xmlns:altovaext="http://www.altova.com/xslt-extensions"
                xmlns:array="http://www.w3.org/2005/xpath-functions/array" xmlns:clitype="clitype"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217"
                xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase"
                xmlns:map="http://www.w3.org/2005/xpath-functions/map"
                xmlns:math="http://www.w3.org/2005/xpath-functions/math"
                xmlns:sps="http://www.altova.com/StyleVision/user-xpath-functions"
                xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance"
                xmlns:xff="http://www.xbrl.org/2010/function/formula"
                xmlns:xfi="http://www.xbrl.org/2008/function/instance" xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                exclude-result-prefixes="altova altova-xfi altovaext array clitype fn iso4217 java link map math sps xbrldi xbrli xff xfi xlink xs xsi">
    <xsl:output version="4.0" method="html" indent="no" encoding="UTF-8"
                doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
    <xsl:decimal-format name="RUS" decimal-separator=',' grouping-separator=' '/>
    <xsl:decimal-format name="EN" decimal-separator='.' grouping-separator=','/>
    <xsl:param name="SV_OutputFormat" select="'HTML'"/>
    <xsl:param name="Language" select="'R'"/>
    <xsl:variable name="XML1" select="/"/>
    <xsl:variable name="altova:nPxPerIn" select="96"/>
    <xsl:variable name="intFormat" select="'#,##0'"/>
    <xsl:variable name="numberFormatPrefix" select="'#,##0.'"/>
    <xsl:variable name="numberFormat_1" select="concat($numberFormatPrefix,'0')"/>
    <xsl:variable name="numberFormat_2" select="concat($numberFormatPrefix,'00')"/>
    <xsl:variable name="numberFormat_3" select="concat($numberFormatPrefix,'000')"/>
    <xsl:variable name="numberFormat_4" select="concat($numberFormatPrefix,'0000')"/>
    <xsl:variable name="numberFormat_5" select="concat($numberFormatPrefix,'00000')"/>
    <xsl:variable name="numberFormat_6" select="concat($numberFormatPrefix,'000000')"/>
    <xsl:template match="/">
        <html>
            <head>
                <title/>
                <meta name="generator"
                      content="Altova StyleVision Enterprise Edition 2019 rel. 3 (x64) (http://www.altova.com)"/>
                <meta http-equiv="X-UA-Compatible" content="IE=5"/>
                <xsl:comment>[if IE]&gt;&lt;STYLE type=&quot;text/css&quot;&gt;.altova-rotate-left-textbox{filter:
                    progid:DXImageTransform.Microsoft.BasicImage(rotation=3)} .altova-rotate-right-textbox{filter:
                    progid:DXImageTransform.Microsoft.BasicImage(rotation=1)} &lt;/STYLE&gt;&lt;![endif]
                </xsl:comment>
                <xsl:comment>[if !IE]&gt;&lt;!</xsl:comment>
                <style type="text/css">.altova-rotate-left-textbox{-webkit-transform: rotate(-90deg) translate(-100%,
                    0%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(-90deg) translate(-100%, 0%);
                    -moz-transform-origin: 0% 0%;-ms-transform: rotate(-90deg) translate(-100%, 0%);
                    -ms-transform-origin: 0% 0%;}.altova-rotate-right-textbox{-webkit-transform: rotate(90deg)
                    translate(0%, -100%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(90deg) translate(0%,
                    -100%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(90deg) translate(0%, -100%);
                    -ms-transform-origin: 0% 0%;}
                </style>
                <xsl:comment>&lt;![endif]</xsl:comment>
                <style type="text/css">@page { margin-left:1.181in; margin-right:0.590in; margin-top:0.787in;
                    margin-bottom:0.787in } @media print { br.altova-page-break { page-break-before: always; }
                    div.altova-page-break { page-break-before: always; } }
                </style>
            </head>
            <body>
                <xsl:for-each select="$XML1">
                    <xsl:for-each select="EFIS_DOC">
                        <!--<xsl:if test="string-length(DOC_REQUISITES/@DOC_NO) &gt; 0">-->
                        <xsl:if test="1 &gt; 0">
                            <div>
                                <span style="font-family:Arial; font-size:10; font-style:italic; ">
                                    <xsl:text>Дата и Время формирования отчета:</xsl:text>
                                </span>
                                <span style="font-family:Arial; font-size:10; font-style:italic; ">
                                    <xsl:text>&#160;</xsl:text>
                                </span>
                                <xsl:for-each select="DOC_REQUISITES">
                                    <xsl:for-each select="@DOC_DATE">
                                        <span style="font-family:Arial; font-size:10; font-style:italic; font-weight:bold; ">
                                            <xsl:variable name="altova:seqContentStrings_0">
                                                <xsl:value-of select="string(.)"/>
                                            </xsl:variable>
                                            <xsl:variable name="altova:sContent_0"
                                                          select="string($altova:seqContentStrings_0)"/>
                                            <xsl:value-of select="$altova:sContent_0"/>
                                        </span>
                                    </xsl:for-each>
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                    <xsl:for-each select="@DOC_TIME">
                                        <span style="font-family:Arial; font-size:10; font-style:italic; font-weight:bold; ">
                                            <xsl:variable name="altova:seqContentStrings_1">
                                                <xsl:value-of
                                                        select="format-number(number(substring(string(string(.)), 1, 2)), '00')"/>
                                                <xsl:text>:</xsl:text>
                                                <xsl:value-of
                                                        select="format-number(number(substring(string(string(.)), 4, 2)), '00')"/>
                                                <xsl:text>:</xsl:text>
                                                <xsl:choose>
                                                    <xsl:when test="contains(string(string(.)), 'Z')">
                                                        <xsl:value-of
                                                                select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00')"/>
                                                    </xsl:when>
                                                    <xsl:when test="contains(string(string(.)), '+')">
                                                        <xsl:value-of
                                                                select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00')"/>
                                                    </xsl:when>
                                                    <xsl:when test="contains(string(string(.)), '-')">
                                                        <xsl:value-of
                                                                select="format-number(number(substring-before(substring(string(string(.)), 7), '-')), '00')"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of
                                                                select="format-number(number(substring(string(string(.)), 7)), '00')"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:variable>
                                            <xsl:variable name="altova:sContent_1"
                                                          select="string($altova:seqContentStrings_1)"/>
                                            <xsl:value-of select="$altova:sContent_1"/>
                                        </span>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </div>
                        </xsl:if>
                        <table style="border:0; border-collapse:collapse; " border="1" width="100%">
                            <xsl:variable name="altova:CurrContextGrid_2" select="."/>
                            <tbody>
                                <tr style="height:19px; ">
                                    <td style="border:0; font:Arial; font-size:12; font-weight:bold; " nowrap="set">
                                        <span style="font-family:Arial; ">
                                            <xsl:text>НКО ЭФИР (АО)</xsl:text>
                                        </span>
                                    </td>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; "/>
                                    <td style="border:0; font:Arial; font-size:12; font-weight:bold; text-align:right; ">
                                        <span style="font-family:Arial; font-size:12; ">
                                            <!--xsl:text>CCX43</xsl:text-->
                                        </span>
                                        <xsl:choose>
                                            <xsl:when test="DOC_REQUISITES/@DOC_TYPE_ID = &apos;CCX43R&apos;">
                                                <span>
                                                    <xsl:text>R</xsl:text>
                                                </span>
                                            </xsl:when>
                                            <xsl:when test="DOC_REQUISITES/@DOC_TYPE_ID = &apos;CCX43P&apos;">
                                                <span>
                                                    <xsl:text>P</xsl:text>
                                                </span>
                                            </xsl:when>
                                        </xsl:choose>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <xsl:for-each select="CCX43">
                            <div style="font:Arial; font-family:Arial; font-size:14; font-weight:bold; text-align:center; ">
                                <span style="font-size:.; ">
                                    <xsl:text>ВЫПИСКА ИЗ РЕЕСТРА СДЕЛОК, ПРИНЯТЫХ В КЛИРИНГ</xsl:text>
                                </span>
                            </div>
                            <br/>
                            <br/>
                            <span style="font-family:Arial; font-size:12; ">
                                <xsl:text>Дата, за которую сформирован отчет:</xsl:text>
                            </span>
                            <span style="font-family:Arial; font-size:12; ">
                                <xsl:text>&#160;</xsl:text>
                            </span>
                            <xsl:for-each select="@ReportDate">
                                <span style="font:Arial; font-family:Arial; font-size:12; font-weight:bold; ">
                                    <xsl:variable name="altova:seqContentStrings_3">
                                        <xsl:value-of select="string(.)"/>
                                    </xsl:variable>
                                    <xsl:variable name="altova:sContent_3"
                                                  select="string($altova:seqContentStrings_3)"/>
                                    <xsl:value-of select="$altova:sContent_3"/>
                                </span>
                            </xsl:for-each>
                            <br/>
                            <br/>
                            <span style="font-family:Arial; font-size:12; ">
                                <xsl:text>Клиринговый код Участника клиринга:</xsl:text>
                            </span>
                            <span>
                                <xsl:text>&#160;</xsl:text>
                            </span>
                            <xsl:for-each select="@FirmId">
                                <span style="font-family:Arial; font-size:12; font-weight:bold; ">
                                    <xsl:value-of select="string(.)"/>
                                </span>
                            </xsl:for-each>
                            <br/>
                            <span style="font-family:Arial; font-size:12; ">
                                <xsl:text>Наименование Участника клиринга:</xsl:text>
                            </span>
                            <span>
                                <xsl:text>&#160;</xsl:text>
                            </span>
                            <xsl:for-each select="@FirmName">
                                <span style="font-family:Arial; font-size:12; font-weight:bold; ">
                                    <xsl:value-of select="string(.)"/>
                                </span>
                            </xsl:for-each>
                            <br/>
                            <br/>
                            <xsl:for-each select="SETTLE">
                                <span style="font-family:Arial; font-size:12; ">
                                    <xsl:text>ТКР:</xsl:text>
                                </span>
                                <span style="font-family:Arial; font-size:12; ">
                                    <xsl:text>&#160;</xsl:text>
                                </span>
                                <xsl:for-each select="@ExtSettleCode">
                                    <span style="font-family:Arial; font-size:12; font-weight:bold; ">
                                        <xsl:value-of select="string(.)"/>
                                    </span>
                                </xsl:for-each>
                                <br/>
                                <xsl:for-each select="SETTLEDATE">
                                    <span style="font-family:Arial; font-size:12; ">
                                        <xsl:text>Дата исполнения обязательств:</xsl:text>
                                    </span>
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                    <xsl:for-each select="@SettleDate">
                                        <span style="font-family:Arial; font-size:12; font-weight:bold; ">
                                            <xsl:variable name="altova:seqContentStrings_4">
                                                <xsl:value-of select="string(.)"/>
                                            </xsl:variable>
                                            <xsl:variable name="altova:sContent_4"
                                                          select="string($altova:seqContentStrings_4)"/>
                                            <xsl:value-of select="$altova:sContent_4"/>
                                        </span>
                                    </xsl:for-each>
                                    <br/>
                                    <br/>
                                    <xsl:for-each select="CURRPAIR">
                                        <span style="font-family:Arial; font-size:12; ">
                                            <xsl:text>Наименование валюты лота:</xsl:text>
                                        </span>
                                        <span>
                                            <xsl:text>&#160;</xsl:text>
                                        </span>
                                        <xsl:for-each select="@CurrencyName">
                                            <span style="font-family:Arial; font-size:12; font-weight:bold; ">
                                                <xsl:value-of select="string(.)"/>
                                            </span>
                                        </xsl:for-each>
                                        <br/>
                                        <span style="font-family:Arial; font-size:12; ">
                                            <xsl:text>Наименование сопряженной валюты:</xsl:text>
                                        </span>
                                        <span>
                                            <xsl:text>&#160;</xsl:text>
                                        </span>
                                        <xsl:for-each select="@CoCurrencyName">
                                            <span style="font-family:Arial; font-size:12; font-weight:bold; ">
                                                <xsl:value-of select="string(.)"/>
                                            </span>
                                        </xsl:for-each>
                                        <br/>
                                        <table style="border:0; border-collapse:collapse; font-family:Arial; font-size:12; "
                                               border="1" width="100%">
                                            <xsl:variable name="altova:CurrContextGrid_5" select="."/>
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Номер</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>сделки</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Дата</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>заключения</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>сделки</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Время</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>заключения</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>сделки</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Инструмент</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Тип</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>сделки</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Нап</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>равле</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>ние</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Объем в</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>валюте лота</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>(в единицах</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>валюты)</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Объем сделки в</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>сопряженной</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>валюте</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Курс</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Комиссионное</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>вознаграждение</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>за клиринговое</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>обслуживание</xsl:text>
                                                        </span>
                                                        <br/>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Код ТКР</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Код</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>клиента</xsl:text>
                                                        </span>
                                                    </th>
                                                    <th>
                                                        <span>
                                                            <xsl:text>Номер</xsl:text>
                                                        </span>
                                                        <br/>
                                                        <span>
                                                            <xsl:text>Заявки</xsl:text>
                                                        </span>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <xsl:for-each select="RECORDS">
                                                    <tr>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <span>
                                                                <xsl:text>&#160;</xsl:text>
                                                            </span>
                                                            <xsl:for-each select="@TradeNo">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@TradeDate">
                                                                <span>
                                                                    <xsl:variable name="altova:seqContentStrings_6">
                                                                        <xsl:value-of select="string(.)"/>
                                                                    </xsl:variable>
                                                                    <xsl:variable name="altova:sContent_6"
                                                                                  select="string($altova:seqContentStrings_6)"/>
                                                                    <xsl:value-of select="$altova:sContent_6"/>
                                                                </span>
                                                            </xsl:for-each>
                                                            <span>
                                                                <xsl:text>&#160;</xsl:text>
                                                            </span>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@TradeTime">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@SecurityId">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                            <span>
                                                                <xsl:text>&#160;</xsl:text>
                                                            </span>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@TradeGroup">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@BuySell">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td nowrap="set">
                                                            <xsl:attribute name="style">
                                                                <xsl:value-of
                                                                        select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                            </xsl:attribute>
                                                            <xsl:for-each select="@Quantity">
                                                                <span>
                                                                    <xsl:value-of select="number(string(.))"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td nowrap="set">
                                                            <xsl:attribute name="style">
                                                                <xsl:value-of
                                                                        select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                            </xsl:attribute>
                                                            <xsl:for-each select="@Value">
                                                                <span>
                                                                    <xsl:value-of
                                                                            select="number(string(.))"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:right; ">
                                                            <xsl:for-each select="@Price">
                                                                <xsl:choose>
                                                                    <xsl:when test="../@Decimals  = 0">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$intFormat,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:when test="../@Decimals  = 1">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_1,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:when test="../@Decimals  = 2">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:when test="../@Decimals  = 3">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_3,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:when test="../@Decimals  = 4">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_4,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:when test="../@Decimals  = 5">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_5,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:when test="../@Decimals  = 6">
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_6,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <xsl:attribute name="style">
                                                                            <xsl:value-of
                                                                                    select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_6,"&apos;; ")'/>
                                                                        </xsl:attribute>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                <span>
                                                                    <xsl:value-of select="number(string(.))"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:right; ">
                                                            <xsl:for-each select="@ClrComm">
                                                                <xsl:attribute name="style">
                                                                    <xsl:value-of
                                                                            select='concat("border-bottom:0; border-top:0; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                                </xsl:attribute>
                                                                <span>
                                                                    <xsl:value-of select="number(string(.))"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@TrdAccId">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@ClientCode">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td style="border-bottom:0; border-top:0; text-align:center; ">
                                                            <xsl:for-each select="@OrderNo">
                                                                <span>
                                                                    <xsl:value-of select="string(.)"/>
                                                                </span>
                                                            </xsl:for-each>
                                                        </td>
                                                    </tr>
                                                </xsl:for-each>
                                                <tr style="border-bottom:0; border-left:0; border-right:0; ">
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td colspan="3"
                                                        style="border-bottom:0; border-left:0; border-right:0; font-style:italic; text-align:right; ">
                                                        <span>
                                                            <xsl:text>Итого покупка:</xsl:text>
                                                        </span>
                                                    </td>
                                                    <td nowrap="set">
                                                        <xsl:attribute name="style">
                                                            <xsl:value-of
                                                                    select='concat("font-weight:bold; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                        </xsl:attribute>
                                                        <span>
                                                            <xsl:value-of
                                                                    select="number(sum( RECORDS[@BuySell =&apos;B&apos; ]/@Quantity ))"/>
                                                        </span>
                                                    </td>
                                                    <td nowrap="set">
                                                        <xsl:attribute name="style">
                                                            <xsl:value-of
                                                                    select='concat("font-weight:bold; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                        </xsl:attribute>
                                                        <span>
                                                                <xsl:value-of
                                                                        select="number(sum( RECORDS[@BuySell =&apos;B&apos; ]/@Value ))"/>
                                                        </span>
                                                    </td>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                    <td style="border-bottom:0; border-left:0; border-right:0; "/>
                                                </tr>
                                                <tr style="border-bottom:0; border-left:0; border-right:0; ">
                                                    <td style="border:0; "/>
                                                    <td style="border:0; "/>
                                                    <td style="border:0; "/>
                                                    <td colspan="3"
                                                        style="border:0; font-style:italic; text-align:right; ">
                                                        <span>
                                                            <xsl:text>Итого продажа:</xsl:text>
                                                        </span>
                                                    </td>
                                                    <td nowrap="set">
                                                        <xsl:attribute name="style">
                                                            <xsl:value-of
                                                                    select='concat("font-weight:bold; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                        </xsl:attribute>
                                                        <span>
                                                                <xsl:value-of
                                                                        select="number(number(number(sum( RECORDS[@BuySell =&apos;S&apos; ]/@Quantity))))"/>
                                                        </span>
                                                    </td>
                                                    <td nowrap="set">
                                                        <xsl:attribute name="style">
                                                            <xsl:value-of
                                                                    select='concat("font-weight:bold; text-align:right; mso-number-format:&apos;",$numberFormat_2,"&apos;; ")'/>
                                                        </xsl:attribute>
                                                        <span>
                                                                <xsl:value-of
                                                                        select="number(sum( RECORDS[@BuySell =&apos;S&apos; ]/@Value ))"/>
                                                        </span>
                                                    </td>
                                                    <td style="border:0; "/>
                                                    <td style="border:0; "/>
                                                    <td style="border:0; "/>
                                                    <td style="border:0; "/>
                                                    <td style="border:0; "/>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </xsl:for-each>
                                    <xsl:apply-templates/>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
